/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.hook;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.items.Launcher;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import com.endertech.minecraft.mods.adhooks.network.SynchronizedProperties;
import java.nio.file.Path;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public enum HookType implements IForgeEnum
{
    PROTOTYPE(Launcher.Properties.of(), Hook.Properties.of(), Rope.Properties.of()),
    PUDGE((Launcher.Properties<?>)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)Launcher.Properties.of().durability(300))).launchVelocity(1.5f))).reelingSpeed(0.7f))).jumpBoost(0.6f))).tarzanJump(0.6f))).shooterWeightFactor(20.0f)), (Hook.Properties<?>)((Object)((Hook.Properties)((Object)((Hook.Properties)((Object)((Hook.Properties)((Object)Hook.Properties.of().strength(10.0f))).damage(0.0f))).resistance(10.0f))).breaksGlass()), (Rope.Properties<?>)((Object)((Rope.Properties)((Object)((Rope.Properties)((Object)((Rope.Properties)((Object)Rope.Properties.of().maxLength(32))).width(3.0f))).elasticity(0.0f))).color(-4259840))),
    SPEAR((Launcher.Properties<?>)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)Launcher.Properties.of().durability(180))).launchVelocity(2.5f))).reelingSpeed(0.5f))).jumpBoost(0.8f))).tarzanJump(0.8f))).shooterWeightFactor(4.0f)), (Hook.Properties<?>)((Object)((Hook.Properties)((Object)((Hook.Properties)((Object)((Hook.Properties)((Object)((Hook.Properties)((Object)Hook.Properties.of().strength(5.0f))).damage(2.0f))).resistance(5.0f))).breaksGlass())).ignoreItems()), (Rope.Properties<?>)((Object)((Rope.Properties)((Object)((Rope.Properties)((Object)((Rope.Properties)((Object)Rope.Properties.of().maxLength(64))).width(4.0f))).elasticity(0.6f))).color(-1090519040))),
    WEB((Launcher.Properties<?>)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)((Launcher.Properties)((Object)Launcher.Properties.of().durability(240))).launchVelocity(2.0f))).reelingSpeed(0.8f))).jumpBoost(1.0f))).tarzanJump(1.0f))).shooterWeightFactor(0.5f)), (Hook.Properties<?>)((Object)((Hook.Properties)((Object)((Hook.Properties)((Object)Hook.Properties.of().strength(2.0f))).damage(0.0f))).resistance(1.0f)), (Rope.Properties<?>)((Object)((Rope.Properties)((Object)((Rope.Properties)((Object)((Rope.Properties)((Object)Rope.Properties.of().maxLength(76))).width(6.0f))).elasticity(0.95f))).color(-1)));

    public final Lazy<Hook> hook;
    public final Lazy<Rope> rope;
    public final Lazy<Launcher> launcher;

    private HookType(Launcher.Properties<?> launcherProps, Hook.Properties<?> hookProps, Rope.Properties<?> ropeProps) {
        AdHooks mod = AdHooks.getInstance();
        Path configDir = mod.getConfigsDir();
        UnitConfig hookConfig = UnitConfig.in((Path)configDir, (String)"hooks", (String)this.getName());
        this.hook = Lazy.of(() -> new Hook(mod, hookConfig, this, hookProps));
        UnitConfig launcherConfig = UnitConfig.in((Path)configDir, (String)"launchers", (String)this.getName());
        this.rope = Lazy.of(() -> new Rope(launcherConfig, ropeProps));
        this.rope.get();
        this.launcher = Lazy.of(() -> new Launcher(mod, launcherConfig, this, launcherProps));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            for (HookType type : HookType.values()) {
                new SynchronizedProperties(type).sendToPlayer((ServerPlayer)player);
            }
        }
    }
}

